@extends('layouts.user')
@section('content')
    <div class="block-center mt-4 wd-xl">
        <!-- START card-->
        <div class="card card-flat">
            <div class="card-header text-center bg-dark">
                <a href="#"><img class="block-center" src="img/logo.png" alt="Image" /></a>
            </div>
            <div class="card-body">
                <p class="text-center py-2">SIGNUP TO GET INSTANT ACCESS.</p>
                <form class="mb-3" id="registerForm" novalidate="novalidate">
                    <div class="form-group">
                        <label class="text-muted" for="signupInputEmail1">Email address</label>
                        <div class="input-group with-focus">
                            <input class="form-control border-right-0" id="signupInputEmail1" type="email" placeholder="Enter email" autocomplete="off" required="required" />
                            <div class="input-group-append">
                                <span class="input-group-text text-muted bg-transparent border-left-0"><em class="fa fa-envelope"></em></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="text-muted" for="signupInputPassword1">Password</label>
                        <div class="input-group with-focus">
                            <input class="form-control border-right-0" id="signupInputPassword1" type="password" placeholder="Password" autocomplete="off" required="required" />
                            <div class="input-group-append">
                                <span class="input-group-text text-muted bg-transparent border-left-0"><em class="fa fa-lock"></em></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="text-muted" for="signupInputRePassword1">Retype Password</label>
                        <div class="input-group with-focus">
                            <input
                                class="form-control border-right-0"
                                id="signupInputRePassword1"
                                type="password"
                                placeholder="Retype Password"
                                autocomplete="off"
                                required="required"
                                data-parsley-equalto="#signupInputPassword1"
                            />
                            <div class="input-group-append">
                                <span class="input-group-text text-muted bg-transparent border-left-0"><em class="fa fa-lock"></em></span>
                            </div>
                        </div>
                    </div>
                    <div class="checkbox c-checkbox mt-0">
                        <label>
                            <input type="checkbox" value="" required="required" name="agreed" />
                            <span class="fa fa-check"></span>
                            I agree with the
                            <a class="ml-1" href="#">terms</a>
                        </label>
                    </div>
                    <button class="btn btn-block btn-primary mt-3" type="submit">Create account</button>
                </form>
                <p class="pt-3 text-center">Have an account?</p>
                <a class="btn btn-block btn-secondary" href="/login">Signup</a>
            </div>
        </div>
        <!-- END card-->
        @include("layouts.includes.footer-page")
    </div>
@endsection
@section('scripts')
    <script src="{{ mix('/js/pages.js') }}"></script>
@endsection
