<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Data Pengguna <span class="badge badge-success"><?php echo e($vtahun_periode->nama); ?></span>
	</div>
</div>
<div class="container-fluid">
	<!-- DATATABLE DEMO 1-->
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				<a href="<?php echo e(route('user.index')); ?>" class="<?php echo e($is_trash ? 'text-success':'text-muted'); ?>"> All
					<span class="badge badge-pill badge-info"><?php echo e($user_count); ?></span>
				</a>
				&nbsp; | &nbsp;
				<a href="<?php echo e(route('user.index')); ?>?status=trash" class="<?php echo e($is_trash ? 'text-muted':'text-danger'); ?>">
					Trash
					<span class="badge badge-pill badge-danger"><?php echo e($trash_count); ?></span>
				</a>
				<div class="float-right">
					<a href="<?php echo e(route('user.create')); ?>" class="btn btn-primary">Data Baru</a>
				</div>
			</div>
		</div>
		<div class="card-body">
			<?php if( session('msg') ): ?>
			<?php $msg = session('msg'); ?>
			<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
				<?php echo $msg['text']; ?>

			</div>
			<?php endif; ?>
			<div class="responsive">
				<table class="table table-bordered table-hover" id="datatable">
					<thead>
						<tr>
							<th class="text-center">No</th>
							<th class="text-center">Nama</th>
							<th class="text-center">Email</th>
							<th class="text-center">Role</th>
							<th class="text-center">Aksi</th>
						</tr>
					</thead>
					<tbody>
						<?php if($records->count()>0): ?>
						<?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td class="text-center"><?php echo e($loop->iteration); ?></td>
							<td><?php echo e($row->nama); ?></td>
							<td><?php echo e($row->email); ?></td>
							<td>
								<?php if($row->role == 1): ?>
								Superadmin
								<?php elseif($row->role == 2): ?>
								Kepala Desa
								<?php elseif($row->role == 3): ?>
								Sekretaris Desa
								<?php else: ?>
								Badan Permusyawaratan Desa
								<?php endif; ?>
							</td>                                
							<td class="text-center">
								<?php if($row->role == 1): ?>
								-
								<?php else: ?>
								<?php if($row->deleted_at == null): ?>
								<button type="button" title="delete" onclick="willRemove('<?php echo e($row->hashid); ?>','DELETE')" class="btn btn-danger btn-sm"> 
									<i class="fa fa-trash"></i>
								</button>
								<a href="<?php echo e(route('user.edit', $row->hashid)); ?>" class="btn btn-success btn-sm"> 
									<i class="fas fa-pencil-alt" ></i>
								</a> 
								<?php else: ?>
								<button type="button" class="btn btn-success btn-sm" onclick="restore('<?php echo e($row->hashid); ?>')" title="Restore">Restore</button>
								<button type="button" title="destroy" onclick="willRemove('<?php echo e($row->hashid); ?>','DESTROY')" class="btn btn-danger btn-sm">Destroy</button>
								<?php endif; ?>
								<?php endif; ?>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<form id="action-form" action="" method="POST">
	<?php echo e(csrf_field()); ?>

	<?php echo e(method_field('PATCH')); ?>

	<input type="hidden" name="id">
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
<script type="text/javascript">
	$(document).ready(function(){
		$('#datatable').DataTable();
	});

	function execRemove(method, hashid) {
		$("#action-form").attr('action', 'user/delete/' + hashid);
		$("#action-form input[name=_method]").val(method);
		$("#action-form").submit();
	}

	function willRemove(id, method) {
		swal({
			title: "Apakah Anda Yakin?",
			text: "anda yakin menghapus data ini?",
			icon: "warning",
			buttons: ["Batal", "Ya"]
		})
		.then(function(willDelete) {
			if (willDelete) {
				if (method === "DELETE") execRemove('PATCH', id)
					else execRemove('DELETE', id)
				}
		});
	};

	function restore (hashid) {
		$("#action-form").attr('action', 'user/restore/' + hashid);
		$("#action-form input[name=_method]").val("POST");
		$("#action-form").submit();
	};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/pengguna/index.blade.php ENDPATH**/ ?>