<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Detail Gaji
	</div>
</div>
<div class="container-fluid">
	<div class="col-sm-12">
		<div class="card">
			<div class="card-header">
				<div class="card-body">
					<?php if( session('msg') ): ?>
					<?php $msg = session('msg'); ?>
					<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
						<?php echo $msg['text']; ?>

					</div>
					<?php endif; ?>
				</div>
				<div class="col-sm-12">
					<div class="row">
						<div class="col-sm-6">
							<form action="<?php echo e(route('gaji.detail')); ?>" method="GET">
								<?php echo csrf_field(); ?>
								<div class="row">
									<div class="col-sm-4 mt-2">
										<select id="periode" name="periode" size="1" class="form-control">
											<option value="">--Pilih Tahun--</option>
											<?php
											$tgl_akhir= date('Y')+3;
											for($i=$tgl_akhir; $i>=date('Y')-1; $i-=1){?>
												<option <?php if($req_periode == $i): ?> selected <?php endif; ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
												<?php
											}
											?>
										</select>
									</div>
									<div class="col-sm-4 mt-2">
										<select id="bulan" name="bulan" size="1" style="display: none;" class="form-control">
											<option value="">--Pilih Bulan--</option>
											<?php
											$tahun = date("Y");
											$bulan1 = date("m");
											$bulan = date("m") * 1-1;
											for ($i = 1; $i < 13; $i++) {
												$nbln = date("F", strtotime($tahun . '-' . $i . '-01'));
												$nrbln = date("m", strtotime($tahun . '-' . $i . '-01'));
												?>
												<option <?php if($req_bulan == $nrbln): ?> selected <?php endif; ?> value="<?php echo e($nrbln); ?>"><?php echo e($nbln); ?></option>
												<?php
											}
											?>
										</select>
									</div>
									<div class="col-sm-3 mt-2" style="display: none;" id="btn-tampilkan">
										<button class="btn btn-primary btn-sm">Tampilkan</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
			<div class="card-body">
				<?php if($displayGaji != null): ?>
				<table class="table table-bordered " id="datatable" style="width: 100%;">
					<thead>
						<tr>
							<th colspan="3" class="text-center bg-gray-dark"><?php echo e(strtoupper('Slip Gaji Bulan')); ?> <strong class="text-yellow"><?php echo e(strtoupper(bulanIndo($req_bulan))); ?></strong></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>Nama</td>
							<td>: <?php echo e($displayGaji->dataGaji[0]->nama); ?></td>
						</tr>
						<tr>
							<td>NIK</td>
							<td>: <?php echo e($displayGaji->dataGaji[0]->nik); ?></td>
						</tr>
						<tr>
							<td>Bagian</td>
							<td>: <?php echo e($displayGaji->dataGaji[0]->bagian); ?></td>
						</tr>
						<tr>
							<td>Jabatan</td>
							<td>: <?php echo e($displayGaji->dataGaji[0]->jabatan); ?></td>
						</tr>
						<tr>
							<td>TMK</td>
							<td>: <?php echo e(tanggalIndo($displayGaji->dataGaji[0]->tmk)); ?></td>
						</tr>
						<tr>
							<td>Bank Transfer</td>
							<td>: <?php echo e($displayGaji->dataGaji[0]->transfer_maspion ? '' : '-'); ?></td>
						</tr>
					</tbody>
					<tbody>
						<tr>
							<th colspan="3" class="text-center bg-gray-light">A. UPAH DAN TUNJANGAN</th>
						</tr>
						<tr>
							<th colspan="3">I. UPAH</th>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;Jumlah Upah</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->Gaji_Pokok), 0)); ?></td>
						</tr>
						<tr>
							<th colspan="3">II. TUNJANGAN</th>
						</tr>
						<tr>
							<th colspan="3">1. STRUKTURAL</th>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Direktur</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->direktur), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Manajer</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->manajer), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Kepala SMF</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->kepala_smf), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Kepala Bagian / Unit</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->kabag), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- SPJ / PJ</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->spj), 0)); ?></td>
						</tr>
						<tr>
							<th colspan="3">2. FUNGSIONAL</th>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Tetap</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->tetap), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Unit</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->unit), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Uang Makan</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->uang_makan), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Transport</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->transport), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Overtime</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->overtime), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Lain-lain</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->lain_lain), 0)); ?></td>
						</tr>
						<tr class="bg-inverse">
							<td style="text-align: center; vertical-align: middle; font-size: 25px;">TOTAL A</td>
							<td style="text-align: center; vertical-align: middle; font-size: 25px;">Rp. <?php echo e(number_format(checkNull($displayGaji->total_a), 0)); ?></td>
						</tr>
						<tr>
							<th colspan="3" class="text-center bg-gray-light">B. POTONGAN</th>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Bank BJB</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->bank_bjb), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- BPJSTK</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->bpjstk), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- BPJS Kesehatan</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->bpjs_kes), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Perawatan</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->perawatan), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Obat</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->obat), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Lain-lain</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->potongan_lain_lain), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- PPH 21</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->pph21), 0)); ?></td>
						</tr>
						<tr>
							<td>&nbsp;&nbsp;&nbsp;- Koperasi</td>
							<td class="text-right">Rp. <?php echo e(number_format(checkNull($displayGaji->dataGaji[0]->koperasi), 0)); ?></td>
						</tr>
						<tr class="bg-inverse">
							<td style="text-align: center; vertical-align: middle; font-size: 18px;">TOTAL B</td>
							<td style="text-align: center; vertical-align: middle; font-size: 18px;">Rp. <?php echo e(number_format(checkNull($displayGaji->total_b), 0)); ?></td>
						</tr>
						<tr>
							<th colspan="3" class="text-center bg-gray-light">C. JUMLAH YANG DITERIMA</th>
						</tr>
						<tr class="bg-success-dark">
							<td style="text-align: center; vertical-align: middle; font-size: 18px;">TOTAL A - TOTAL B</td>
							<td style="text-align: center; vertical-align: middle; font-size: 18px;">Rp. <?php echo e(number_format(checkNull($displayGaji->totalAll), 0)); ?></td>
						</tr>
						<tr>
							<th colspan="3" class="text-center">
								<form action="<?php echo e(route('gaji.download')); ?>" method="POST">
									<?php echo csrf_field(); ?>
									<input type="hidden" name="periode" value="<?php echo e($req_periode); ?><?php echo e($req_bulan); ?>">
									<button class="btn btn-danger btn-sm form-control">Download</button>
								</form>
							</th>
						</tr>
					</tbody>
				</table>
				<?php else: ?>
				<table class="table table-bordered table-hover" id="datatable" style="width: 100%;">
					<thead>
						<tr>
							<th colspan="3" class="text-center bg-gray-dark">SLIP GAJI TIDAK DITEMUKAN</th>
						</tr>
					</thead>
				</table>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-area'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
<script type="text/javascript">
	var table = null;
	$(document).ready(function(){
		console.log('', "");
		if (<?php echo e($req_periode); ?> == 0) {
			$('#bulan').hide();
			$('#btn-tampilkan').hide();
		}else{
			$('#btn-tampilkan').show();
			$('#bulan').show();
		}
	});

	$('#periode').change(function(){
		if ($(this).val() == ""){
			$('#bulan').hide();
		}else{
			$('#bulan').show();
		}
	});

	$('#bulan').change(function(){
		if ($(this).val() == ""){
			$('#btn-tampilkan').hide();
		}else{
			$('#btn-tampilkan').show();
		}
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\rs-app\rs-presensi-web\resources\views/pages/personalia/gaji/detail.blade.php ENDPATH**/ ?>