<?php


use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/config', function(){
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
                
    return 'success';
});

Route::bind('id', function ( $id ) {
	$decoded = \Hashids::decode($id);
	return count($decoded) > 0 ? $decoded[0] : false;
});

Route::get('/', 'Auth\LoginController@showLoginForm')->name('login');
Route::get('/logout', 'Auth\LoginController@logout')->name('logout');
Route::post('/login/proses', 'Auth\LoginController@login')->name('login.proses');

Route::group(['middleware' => ['auth.user']], function () {
	/*
	|--------------------------------------------------------------------------
	| Dashboard Routes
	|--------------------------------------------------------------------------
	|
	*/
	Route::get('/dashboard', 'DashboardController@index')->name('dashboard');


		/*
		|--------------------------------------------------------------------------
		| Pengguna Routes
		|--------------------------------------------------------------------------
		|
		*/
		Route::group(['prefix' => 'personalia'], function () {
			/*
			|--------------------------------------------------------------------------
			| Personalia Absensi Routes
			|--------------------------------------------------------------------------
			|
			*/
			Route::get('absensi/', 'Personalia\AbsensiController@index')->name('absensi.index');
			Route::get('absensi/verify-location', 'Personalia\AbsensiController@verifyLocation')->name('absensi.verify_location');
			Route::post('absensi/store', 'Personalia\AbsensiController@store')->name('absensi.store');
			Route::post('absensi/upload-foto', 'Personalia\AbsensiController@uploadFoto')->name('absensi.upload_foto');

			/*
			|--------------------------------------------------------------------------
			| Personalia Slip Gaji Routes
			|--------------------------------------------------------------------------
			|
			*/
			Route::get('gaji/', 'Personalia\GajiController@index')->name('gaji.index');
			Route::post('gaji/konfirmasi', 'Personalia\GajiController@konfirmasi')->name('gaji.konfirmasi');
			Route::get('gaji/detail', 'Personalia\GajiController@detail')->name('gaji.detail');
			Route::post('gaji/download', 'Personalia\GajiController@download')->name('gaji.download');

			/*
			|--------------------------------------------------------------------------
			| Pengguna Routes
			|--------------------------------------------------------------------------
			|
			*/
			Route::get('/', 'Pengguna\UserController@index')->name('user.index');
			Route::get('create', 'Pengguna\UserController@create')->name('user.create');
			Route::post('store', 'Pengguna\UserController@store')->name('user.store');
			Route::get('{id}/edit', 'Pengguna\UserController@edit')->name('user.edit');
			Route::put('{id}/edit', 'Pengguna\UserController@update')->name('user.update');
			Route::patch('delete/{id}', 'Pengguna\UserController@delete')->name('user.delete');
			Route::delete('delete/{id}', 'Pengguna\UserController@destroy')->name('user.destroy');
			Route::post('restore/{id}', 'Pengguna\UserController@restore')->name('user.restore');
			
		});


	});