<?php

if (!function_exists('api_url')) {
    /**
     * convert string date system to string date indo
     *
     * @param string
     * @return string
     */
    function api_url($url)
    {
    	//return "http://103.184.52.66/WebApiPersonaliaApp/index.php/".$url;
    	return "http://45.112.125.33/WebApiPersonaliaApp/index.php/".$url;
    }
}

if (!function_exists('url_foto')) {
    /**
     * convert string date system to string foto url
     *
     * @param string
     * @return string
     */
    function url_foto($foto)
    {
        //return "http://103.184.52.66/WebApiPersonaliaApp/foto_profile/".$foto;
        return "http://45.112.125.33/WebApiPersonaliaApp/foto_profile/".$foto;
    }
}

if (!function_exists('checkNUll')) {
    /**
     * convert string date system to string foto url
     *
     * @param string
     * @return string
     */
    function checkNUll($string)
    {
        $num = "";
        if ($string == null || empty($string) || $string == ".0000") {
            $num = 0;
        } else {
            $num = str_replace(".0000","", $string);
        }
        return $num;
    }
}

if (!function_exists('tanggalIndo')) {

    /**
     * convert string date system to string date indo
     *
     * @param string
     * @return string
     */
    function tanggalIndo($date,$short_month = false)
    {
        $time = strtotime($date);

        return date('d',$time)." ".bulanIndo(date('m',$time),$short_month)." ".date('Y',$time);
    }
}
if (!function_exists('bulanIndo')) {

    /**
     * conver number of month to month name
     *
     * @param int
     * @return string
     */
    function bulanIndo($no,$short = false) {
        $no = (int) $no;
        switch ($no) {
            case 1:return $short ? 'Jan' : 'Januari';break;
            case 2:return $short ? 'Feb' : 'Februari';break;
            case 3:return $short ? 'Mar' : 'Maret';break;
            case 4:return $short ? 'Apr' : 'April';break;
            case 5:return $short ? 'Mei' : 'Mei';break;
            case 6:return $short ? 'Jun' : 'Juni';break;
            case 7:return $short ? 'Jul' : 'Juli';break;
            case 8:return $short ? 'Agu' : 'Agustus';break;
            case 9:return $short ? 'Sep' : 'September';break;
            case 10:return $short ? 'Okt' : 'Oktober';break;
            case 11:return $short ? 'Nov' : 'November';break;
            case 12:return $short ? 'Des' : 'Desember';break;
        }
        return '-';
    }
}

if (!function_exists('rangeDate')) {

    /**
     * conver number of month to month name
     *
     * @param int
     * @return string
     */
    function rangeDate($date_start,$date_end,$short_month = false, $separator = '-') {
        $start=strtotime($date_start);
        $end=strtotime($date_end);

        if ($date_start == $date_end) 
        {
            return date('d',$start).' '.bulanIndo(date('m',$start),$short_month).' '.date('Y',$start);
        }
        elseif (date('Y-m',$start) == date('Y-m',$end)) 
        {
            return date('d',$start)." {$separator} ".date('d',$end).' '.bulanIndo(date('m',$start),$short_month).' '.date('Y',$start);
        }
        elseif (date('Y',$start) == date('Y',$end))
        {
            return date('d',$start).' '.bulanIndo(date('m',$start),$short_month)." {$separator} ".date('d',$end).' '.bulanIndo(date('m',$end),$short_month).' '.date('Y',$end);
        }
        else
        {
            return date('d',$start).bulanIndo(date('m',$start),$short_month).' '.date('Y',$start)." {$separator} ".date('d',$end).' '.bulanIndo(date('m',$end),true).' '.date('Y',$end);
        }
    }
}

if (!function_exists('hashDecoded')) {

    /**
     * decode hashids
     *
     * @param string
     * @return string
     */
    function hashDecoded($hash) {
        $decode = \Hashids::decode($hash);
        return count($decode) > 0  ? $decode[0] : false;
    }
}

if (!function_exists('dayToNumber')) {

    /**
     * convert day to number
     *
     * @param string
     * @return int
     */
    function dayToNumber($day) {
        switch ($day) {
            case 'senin':return 1;break;
            case 'selasa':return 2;break;
            case 'rabu':return 3;break;
            case 'kamis':return 4;break;
            case 'jumat':return 5;break;
            case 'sabtu':return 6;break;
            case 'minggu':return 7;break;
        }
        return 0;
        
    }
}

if (!function_exists('numberToDay')) {

    /**
     * convert number to day
     *
     * @param string
     * @return int
     */
    function numberToDay($number) 
    {
        switch ($number) {
            case 1:return 'senin';break;
            case 2:return 'selasa';break;
            case 3:return 'rabu';break;
            case 4:return 'kamis';break;
            case 5:return 'jumat';break;
            case 6:return 'sabtu';break;
            case 7:return 'minggu';break;
        }
        return '';
        
    }
}

if (!function_exists('slug')) {

    /**
     * convert raw string to slug format
     *
     * @param string
     * @param string (nullable)
     * @return string
     */
    function slug($str,$delimiter = '-')
    {
        $slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace("/[']/", '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
        return $slug;
    }
}

if (!function_exists('numberToNameColumn')) {

    /**
     * convert number to name column excel
     *
     * @param int
     * @return string
     */
    function numberToNameColumn($num) {
        $numeric = ($num - 1) % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval(($num - 1) / 26);
        if ($num2 > 0) {
            return numberToNameColumn($num2) . $letter;
        } else {
            return $letter;
        }
    }
}

if (!function_exists('pointInPolygon')) {

    
    function pointInPolygon($point, $polygon, $pointOnVertex = true) {
        $this->pointOnVertex = $pointOnVertex;

        // Transform string coordinates into arrays with x and y values
        $point = $this->pointStringToCoordinates($point);
        $vertices = array(); 
        foreach ($polygon as $vertex) {
            $vertices[] = $this->pointStringToCoordinates($vertex); 
        }

        // Check if the point sits exactly on a vertex
        if ($this->pointOnVertex == true and $this->pointOnVertex($point, $vertices) == true) {
            return "vertex";
        }

        // Check if the point is inside the polygon or on the boundary
        $intersections = 0; 
        $vertices_count = count($vertices);

        for ($i=1; $i < $vertices_count; $i++) {
            $vertex1 = $vertices[$i-1]; 
            $vertex2 = $vertices[$i];
            if ($vertex1['y'] == $vertex2['y'] and $vertex1['y'] == $point['y'] and $point['x'] > min($vertex1['x'], $vertex2['x']) and $point['x'] < max($vertex1['x'], $vertex2['x'])) { // Check if point is on an horizontal polygon boundary
                return "boundary";
            }
            if ($point['y'] > min($vertex1['y'], $vertex2['y']) and $point['y'] <= max($vertex1['y'], $vertex2['y']) and $point['x'] <= max($vertex1['x'], $vertex2['x']) and $vertex1['y'] != $vertex2['y']) { 
                $xinters = ($point['y'] - $vertex1['y']) * ($vertex2['x'] - $vertex1['x']) / ($vertex2['y'] - $vertex1['y']) + $vertex1['x']; 
                if ($xinters == $point['x']) { // Check if point is on the polygon boundary (other than horizontal)
                    return "boundary";
                }
                if ($vertex1['x'] == $vertex2['x'] || $point['x'] <= $xinters) {
                    $intersections++; 
                }
            } 
        } 
        // If the number of edges we passed through is odd, then it's in the polygon. 
        if ($intersections % 2 != 0) {
            return "inside";
        } else {
            return "outside";
        }
    }

    function pointOnVertex($point, $vertices) {
        foreach($vertices as $vertex) {
            if ($point == $vertex) {
                return true;
            }
        }

    }

    function pointStringToCoordinates($pointString) {
        $coordinates = explode(" ", $pointString);
        return array("x" => $coordinates[0], "y" => $coordinates[1]);
    }
}