<?php
$serverName = "116.197.129.73";
$connectionOptions = array(
     "database" => "koperasi",
     "uid" => "sa",
     "pwd" => "mht2008"
);

function exception_handler($exception)
{
     echo "<h1>Failure</h1>";
     echo "Uncaught exception: ", $exception->getMessage();
     echo "<h1>PHP Info for troubleshooting</h1>";
     phpinfo();
}

set_exception_handler('exception_handler');

// Establishes the connection
$conn = sqlsrv_connect($serverName, $connectionOptions);
if ($conn === false) {
     die(formatErrors(sqlsrv_errors()));
}

// Select Query
$tsql = "SELECT @@Version AS SQL_VERSION";

// Executes the query
$stmt = sqlsrv_query($conn, $tsql);

// Error handling
if ($stmt === false) {
     die(formatErrors(sqlsrv_errors()));
}
?>

<h1> Success Results : </h1>

<?php
while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
     echo $row['SQL_VERSION'] . PHP_EOL;
}

sqlsrv_free_stmt($stmt);
sqlsrv_close($conn);

function formatErrors($errors)
{
     // Display errors
     echo "<h1>SQL Error:</h1>";
     echo "Error information: <br/>";
     print_r($errors);
     foreach ($errors as $error) {
          echo "SQLSTATE: " . $error['SQLSTATE'] . "<br/>";
          echo "Code: " . $error['code'] . "<br/>";
          echo "Message: " . $error['message'] . "<br/>";
     }
}
?>