@extends('layouts.app')
@section('content')
<div class="content-heading">
	<div>
		Pengaturan User
	</div>
</div>
<div class="container-fluid">
	<!-- DATATABLE DEMO 1-->
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				<a href="{{ route('user.index') }}" class="{{ $is_trash ? 'text-success':'text-muted' }}"> All
					<span class="badge badge-pill badge-info">{{ $user_count }}</span>
				</a>
				&nbsp; | &nbsp;
				<a href="{{ route('user.index') }}?status=trash" class="{{ $is_trash ? 'text-muted':'text-danger' }}">
					Trash
					<span class="badge badge-pill badge-danger">{{ $trash_count }}</span>
				</a>
				<div class="float-right">
					<a href="{{ route('user.create') }}" class="btn btn-primary">Data Baru</a>
				</div>
			</div>
		</div>
		<div class="card-body">
			@if( session('msg') )
			<?php $msg = session('msg'); ?>
			<div class="alert alert-{{ $msg['type'] }} alert-remove">
				{!! $msg['text'] !!}
			</div>
			@endif
			<table class="table table-bordered table-hover" id="datatable">
				<thead>
					<tr>
						<th class="text-center">No</th>
						<th class="text-center">Nama</th>
						<th class="text-center">Email</th>
						<th class="text-center">Centra Batik</th>
						<th class="text-center">Role</th>
						<th class="text-center">Aksi</th>
					</tr>
				</thead>
				<tbody>
					@if($records->count()>0)
					@foreach($records as $row)
					<tr>
						<td class="text-center">{{ $loop->iteration }}</td>
						<td>{{ $row->nama }}</td>
						<td>{{ $row->email }}</td>
						<td>
							@if(is_null($row->SentraBatik))
							-
							@else
							{{ $row->SentraBatik->nama }}
							@endif
						</td>
						<td>
							@if($row->role == 1)
							Superadmin
							@elseif($row->role == 2)
							Admin
							@else
							Pengguna
							@endif
						</td>                                
						<td class="text-center">
							@if($row->role == 1)
							-
							@else
							@if($row->deleted_at == null)
							<button type="button" title="delete" onclick="willRemove('{{ $row->id }}','DELETE')" class="btn btn-danger btn-sm"> 
								<i class="fa fa-trash"></i>
							</button>
							<a href="{{ route('user.edit', $row->id) }}" class="btn btn-success btn-sm"> 
								<i class="fas fa-pencil-alt" ></i>
							</a> 
							@else
							<button type="button" class="btn btn-success btn-sm" onclick="restore('{{ $row->id }}')" title="Restore">Restore</button>
							<button type="button" title="destroy" onclick="willRemove('{{ $row->id }}','DESTROY')" class="btn btn-danger btn-sm">Destroy</button>
							@endif
							@endif
						</td>
					</tr>
					@endforeach
					@endif
				</tbody>
			</table>
            </div>
        </div>
    </div>
    <form id="action-form" action="" method="POST">
        {{ csrf_field() }}
        {{ method_field('PATCH') }}
        <input type="hidden" name="id">
    </form>
@endsection
@section('scripts')
    <script src="{{ mix('/js/sweetalert.js') }}"></script>
    <script src="{{ mix('/js/datatable.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            $('#datatable').DataTable();
        });

        function execRemove(method, hashid) {
            $("#action-form").attr('action', 'user/delete/' + hashid);
            $("#action-form input[name=_method]").val(method);
            $("#action-form").submit();
        }

        function willRemove(id, method) {
            swal({
                title: "Apakah Anda Yakin?",
                text: "anda yakin menghapus data ini?",
                icon: "warning",
                buttons: ["Batal", "Ya"]
            })
            .then(function(willDelete) {
                if (willDelete) {
                    if (method === "DELETE") execRemove('PATCH', id)
                    else execRemove('DELETE', id)
                }
            });
        };

        function restore (hashid) {
            $("#action-form").attr('action', 'user/restore/' + hashid);
            $("#action-form input[name=_method]").val("POST");
            $("#action-form").submit();
        };
    </script>
@endsection