@extends('layouts.app')
@section('content')
<div class="content-heading">
	<div>
		Identifikasi Batik
	</div>
</div>
<div class="container-fluid">
	<div class="col-md-6 offset-md-3">
		<div class="card">
			<div class="card-header">
				<div class="card-title">
					Edit Identifikasi Batik
					<div class="float-right">

					</div>
				</div>
			</div>
			<div class="card-body">
				<form action="{{ route('batik.update', $batik->id) }}" method="POST" enctype="multipart/form-data">
					@method('PUT')
					@csrf
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama" value="{{ old('nama') ? old('nama'):$batik->nama }}" placeholder="" />
							@if ($errors->has('nama'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('nama') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Sentra Batik</label>
						<div class="col-sm-7">
							<select required name="sentra_id" class="custom-select custom-select-xl @error('sentra_id') is-invalid @enderror">{{ old('sentra_id') }}>
								@foreach($sentra as $row)
								<option value="{{$row->id}}" @if(old('sentra_id', $batik->sentra_id) == $row->id) selected @endif>{{ $row->nama }}</option>
								@endforeach
							</select>
							@error('sentra_id')
							<div class="invalid-feedback">{{$message}}</div>
							@enderror
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Asal Daerah</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="asal_daerah" value="{{ old('asal_daerah') ? old('nama'):$batik->asal_daerah }}" placeholder="" />
							@if ($errors->has('asal_daerah'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('asal_daerah') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Cara Pembuatan</label>
						<div class="col-sm-7">
							<textarea autofocus class="form-control" required type="text" name="cara_pembuatan" placeholder="">{{ old('cara_pembuatan') ? old('nama'):$batik->cara_pembuatan }}</textarea>
							@if ($errors->has('cara_pembuatan'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('cara_pembuatan') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Warna</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="warna" value="{{ old('warna') ? old('nama'):$batik->warna }}" placeholder="" />
							@if ($errors->has('warna'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('warna') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Motif</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="motif" value="{{ old('motif') ? old('nama'):$batik->motif }}" placeholder="" />
							@if ($errors->has('motif'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('motif') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama Pembuat</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama_pembuat" value="{{ old('nama_pembuat') ? old('nama'):$batik->nama_pembuat }}" placeholder="" />
							@if ($errors->has('nama_pembuat'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('nama_pembuat') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Foto</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" type="file" name="foto"/>
							@if ($errors->has('foto'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('foto') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="col-sm-12">
						<div class="form-group row">
							<div class="col-xl-12 text-center">
								<a href="{{ route('batik.index') }}" class="btn btn-secondary">Kembali</a>
								<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>

@endsection
@section('scripts')

@endsection