<?php $__env->startSection('content'); ?>
<div class="content-heading">
    <div>
        Pengajuan Anggaran <span class="badge badge-success"><?php echo e($vtahun_periode->nama); ?></span>
    </div>
</div>
<div class="container-fluid">
  <div class="card">
    <div class="card-header">
        <div class="card-title">
            <a href="<?php echo e(route('pengajuan_anggaran.index')); ?>" class="<?php echo e($is_trash ? 'text-success':'text-muted'); ?>"> All
                <span class="badge badge-pill badge-info"><?php echo e($anggaran_count); ?></span>
            </a>
            &nbsp; | &nbsp;
            <a href="<?php echo e(route('pengajuan_anggaran.index')); ?>?status=trash" class="<?php echo e($is_trash ? 'text-muted':'text-danger'); ?>">
                Trash
                <span class="badge badge-pill badge-danger"><?php echo e($trash_count); ?></span>
            </a>
            <div class="float-right">
                <a href="<?php echo e(route('pengajuan_anggaran.create')); ?>" class="btn btn-primary">Tambah Pengajuan</a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php if( session('msg') ): ?>
        <?php $msg = session('msg'); ?>
        <div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
            <?php echo $msg['text']; ?>

        </div>
        <?php endif; ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover table-sm" id="datatable" style="width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Tanggal Pengajuan</th>
                        <th class="text-center">Nama</th>
                        <th class="text-center">Tipe</th>
                        <th class="text-center">Nominal <br> Rp.</th>
                        <th class="text-center">Uraian</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; ?>
                    <?php if($records->count()>0): ?>
                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($no++); ?></td>
                        <td class="text-center"><?php echo e(date('d F Y', strtotime($row->tanggal_diajukan))); ?></td>
                        <td class="text-center"><?php echo e($row->nama); ?></td>
                        <td class="text-center">
                            <?php if($row->tipe == "masuk"): ?>
                                <span class="badge badge-success">Masuk</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Keluar</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-right"><?php echo e(number_format($row->nominal,0,',','.')); ?></td>
                        <td class="text-center"><?php echo e($row->uraian); ?></td>
                        <td class="text-center">
                            <?php if($row->status == 0): ?>
                                <span class="badge badge-warning">Belum Disetujui</span>
                            <?php elseif($row->status == 1): ?>
                                <span class="badge badge-success">Sudah Disetujui</span>
                            <?php elseif($row->status == 4): ?>
                                <span class="badge badge-danger">Ditolak</span>
                            <?php else: ?>
                                <span class="badge badge-success">Di Hapus</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                                <?php if( $row->deleted_at == null ): ?>
                                    <?php if($row->status != 1 && $row->status != 4): ?>
                                    <a href="<?php echo e(route('pengajuan_anggaran.edit',$row->hashid)); ?>" class="btn btn-success btn-sm">Edit</a> 
                                    <button type="button" title="delete" onclick="willRemove('<?php echo e($row->hashid); ?>','DELETE')" class="btn btn-danger btn-sm">Delete</button>
                                    <?php elseif($row->status == 4): ?>
                                    <button type="button" title="delete" onclick="willRemove('<?php echo e($row->hashid); ?>','DELETE')" class="btn btn-danger btn-sm">Delete</button>
                                    <?php else: ?>
                                    -
                                    <?php endif; ?>
                                <?php else: ?>
                                <button type="button" class="btn btn-success btn-sm" onclick="restore('<?php echo e($row->hashid); ?>')" title="Restore">Restore</button>
                                <button type="button" class="btn btn-danger btn-sm" onclick="willRemove('<?php echo e($row->hashid); ?>','DESTROY')" title="destroy">Destroy</button>
                                <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>
<form id="action-form" action="" method="POST">
    <?php echo e(csrf_field()); ?>

    <?php echo e(method_field('PATCH')); ?>

    <input type="hidden" name="id">
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $('#datatable').DataTable();
    });

    function execRemove(method, hashid) {
        $("#action-form").attr('action', 'tahun-periode/delete/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willRemove(id, method) {
        swal({
            title: "Apakah Anda Yakin?",
            text: "anda yakin menghapus data ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willDelete) {
            if (willDelete) {
                if (method === "DELETE") execRemove('PATCH', id)
                    else execRemove('DELETE', id)
                }else{
                    swal("Aksi Dibatalkan", "", "error");
                }
            });
    };

    function execStatus(method, hashid) {
        $("#action-form").attr('action', 'tahun-periode/set-status/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willStatus(id, method, periode) {
        swal({
            title: "Aktifkan Tahun Periode?",
            text: "anda yakin ingin mengaktifkan "+periode+" ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willStatus) {
            if (willStatus) {
                if (method === "STATUS") execStatus('PUT', id)
                    else execStatus('STATUS', id)

                }
        });
    }

    function restore (hashid) {
        $("#action-form").attr('action', 'tahun-periode/restore/' + hashid);
        $("#action-form input[name=_method]").val("POST");
        $("#action-form").submit();
    };
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/pengajuan_anggaran/index.blade.php ENDPATH**/ ?>