<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Anggaran
	</div>
</div>
<div class="container-fluid">
	<div class="col-md-6 offset-md-3">
		<div class="card">
			<div class="card-header">
				<div class="card-title">
					Edit Anggaran
					<div class="float-right">
						
					</div>
				</div>
			</div>
			<div class="card-body">
			<?php if( session('msg') ): ?>
			<?php $msg = session('msg'); ?>
			<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
				<?php echo $msg['text']; ?>

			</div>
			<?php endif; ?>
				<form action="<?php echo e(route('anggaran.update', $anggaran->hashid)); ?>" method="POST">
					<?php echo method_field('PUT'); ?>
					<?php echo csrf_field(); ?>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama" value="<?php echo e(old('nama') ? old('nama') : $anggaran->nama); ?>" placeholder="" />
							<?php if($errors->has('nama')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('nama')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Tipe</label>
						<div class="col-sm-7">
							<select class="form-control" name="tipe">
								<option <?php echo e($anggaran->nama == "masuk" ? 'selected' : ''); ?> value="masuk">Masuk</option>
								<option <?php echo e($anggaran->nama == "keluar" ? 'selected' : ''); ?> value="keluar">Keluar</option>
							</select>
							<?php if($errors->has('tipe')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('tipe')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nominal</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nominal" value="<?php echo e(old('nominal') ? old('nominal') : 'Rp.'.number_format($anggaran->nominal, 0,',','.')); ?>" id="rupiah" onkeypress="return hanyaAngka(event)" placeholder="Rp. "/>
							<?php if($errors->has('nominal')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('nominal')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Uraian</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="uraian" value="<?php echo e(old('uraian') ? old('uraian') : $anggaran->uraian); ?>" placeholder="" />
							<?php if($errors->has('uraian')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('uraian')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Bukti</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" type="file" name="bukti" value="<?php echo e(old('bukti') ? old('bukti') : $anggaran->bukti); ?>" placeholder="" />
							<?php if($anggaran->bukti != null): ?>
								<img src="<?php echo e(asset('storage/bukti/'.$anggaran->bukti)); ?>" width="200px">
							<?php else: ?>
								<span class="badge badge-danger badge-sm mt-2">Belum ada bukti terkait</span>
							<?php endif; ?>
							<?php if($errors->has('bukti')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('bukti')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Status</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" disabled name="nama" value="<?php echo e($anggaran->status == 1 ? 'Approved' : 'Approving'); ?>" placeholder="" />
							<?php if($errors->has('nama')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('nama')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="form-group row">
							<div class="col-xl-12 text-center">
								<a href="<?php echo e(route('anggaran.index')); ?>" class="btn btn-secondary">Kembali</a>
								<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/anggaran/edit.blade.php ENDPATH**/ ?>