<?php $__env->startSection('content'); ?>
<div class="content-heading">
    <div>
        Approval Anggaran <span class="badge badge-success"><?php echo e($vtahun_periode->nama); ?></span>
    </div>
</div>
<div class="container-fluid">
  <div class="card">
    <div class="card-header">
        <div class="card-title">
            <a href="<?php echo e(route('approval_anggaran.index')); ?>?t=<?php echo e($tahun); ?>" class="<?php echo e(!is_null($status) ? 'text-primary':'text-muted'); ?>"> Pengajuan Baru
                <span class="badge badge-pill badge-info"><?php echo e($anggaran_baru_count); ?></span>
            </a>
            &nbsp; | &nbsp;
            <a href="<?php echo e(route('approval_anggaran.index')); ?>?t=<?php echo e($tahun); ?>&status=disetujui" class="<?php echo e($status == 'disetujui' ? 'text-muted':'text-success'); ?>">
                Pengajuan Disetujui
                <span class="badge badge-pill badge-danger"><?php echo e($anggaran_diterima_count); ?></span>
            </a>
            &nbsp; | &nbsp;
            <a href="<?php echo e(route('approval_anggaran.index')); ?>?t=<?php echo e($tahun); ?>&status=ditolak" class="<?php echo e($status == 'ditolak' ? 'text-muted':'text-danger'); ?>">
                Pengajuan Ditolak
                <span class="badge badge-pill badge-danger"><?php echo e($anggaran_ditolak_count); ?></span>
            </a>
        </div>
    </div>
    <div class="card-body">
        <?php if( session('msg') ): ?>
        <?php $msg = session('msg'); ?>
        <div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
            <?php echo $msg['text']; ?>

        </div>
        <?php endif; ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover table-sm" id="datatable" style="width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Tanggal Pengajuan</th>
                        <th class="text-center">Nama</th>
                        <th class="text-center">Tipe</th>
                        <th class="text-center">Nominal <br> Rp.</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; ?>
                    <?php if($pengajuan_anggaran->count()>0): ?>
                    <?php $__currentLoopData = $pengajuan_anggaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($no++); ?></td>
                        <td class="text-center"><?php echo e(date('d F Y', strtotime($row->tanggal_diajukan))); ?></td>
                        <td class="text-center"><?php echo e($row->nama); ?></td>
                        <td class="text-center">
                            <?php if($row->tipe == "masuk"): ?>
                                <span class="badge badge-success">Pemasukan</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Pengeluaran</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-right"><?php echo e(number_format($row->nominal,2, ',','.')); ?></td>
                        <td class="nowrap text-center">
                            <?php if(is_null($row->tanggal_disetujui)): ?>
                            <?php else: ?>
                                <?php if($row->status == 1): ?><span class="badge badge-success"><i class="fa fa-check">&nbsp;Diterima</i></span>
                                <?php elseif($row->status == 4): ?><span class="badge badge-danger"><i class="fas fa-times">&nbsp;Ditolak</i></span>
                                <?php endif; ?>
                                <br>
                                <small>
                                    Oleh: <?php echo e('Kepala Desa'); ?><br>
                                    Pada: <?php echo e($row->updated_at); ?>

                                    <?php if(!is_null($row->bukti)): ?>
                                        <a href="<?php echo e(asset('storage/bukti/'.$row->bukti)); ?>" target="_blank">Lihat Lampiran</a>
                                    <?php endif; ?>
                                </small>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <?php if(is_null($row->tanggal_disetujui)): ?>
                            <button type="button" title="delete" onclick="willStatusTolak('<?php echo e($row->hashid); ?>','STATUS', '<?php echo e($row->nama); ?>')" class="btn btn-danger btn-sm">Tolak</button>
                            <button type="button" title="delete" onclick="willStatusSetujui('<?php echo e($row->hashid); ?>','STATUS', '<?php echo e($row->nama); ?>')" class="btn btn-success btn-sm">Setujui</button> 
                            <?php else: ?>
                                <?php if($row->status == 4): ?>
                                <button type="button" title="delete" onclick="willStatusSetujui('<?php echo e($row->hashid); ?>','STATUS', '<?php echo e($row->nama); ?>')" class="btn btn-success btn-sm">Update Setujui</button>
                                <?php else: ?>
                                <button type="button" title="delete" onclick="willStatusTolak('<?php echo e($row->hashid); ?>','STATUS', '<?php echo e($row->nama); ?>')" class="btn btn-danger btn-sm">Update Tolak</button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>
<form id="action-form" action="" method="POST">
    <?php echo e(csrf_field()); ?>

    <?php echo e(method_field('PATCH')); ?>

    <input type="hidden" name="id">
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready(function(){
        var table = $('#datatable').DataTable({
            order:[[6,'<?php echo e(empty($status) ? "asc":"desc"); ?>']],
            "lengthMenu": [[50, 100, -1], [50, 100, "All"]],
            "dom":"<'row'<'col-sm-3'l><'col-sm-3'B><'col-sm-6'f><'col-sm-12'rtip>>",
            scrollX:true,
            "buttons": [
                    {
                        extend: 'excelHtml5',
                        text: 'Cetak <?php echo e(is_null($status) ? "Pengajuan Baru" : "Anggaran ".ucwords($status)); ?>',
                        className: 'btn-green',
                        filename: 'export pengajuan anggaran (<?php echo e(is_null($status) ? "pengajuan baru" : $status); ?>) periode <?php echo e(str_replace("/","",$vtahun_periode->nama)); ?>',
                        title: 'Pengajuan Anggaran (<?php echo e(is_null($status) ? "Pengajuan Baru" : ucwords($status)); ?>)',
                        messageTop: 'Desa BangunJaya - <?php echo e(str_replace("/","",$vtahun_periode->nama)); ?>',
                        exportOptions: {
                            columns: [ 0,1,2,3,4,5,6 ]
                        },
                         customize: function(xlsx) {
                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
             
                            // Loop over the cells in column `C`
                            $('row c[r^="G"]', sheet).each( function () {
                                // Get the value
                                if ( $('is t', this).text() != 'Lampiran' && $('is t', this).text() != '' ) 
                                {
                                    $(this).attr('t', 'str');
                                    //append the formula
                                    $(this).append('<f>' + 'HYPERLINK("'+$('is t', this).text()+'","Lihat Lampiran")'+ '</f>');
                                    //remove the inlineStr
                                    $('is', this).remove();
                                    // (3.) underline
                                    $(this).attr( 's', '4' );
                                }
                            });
                        }
                    }
                ],
        });
    });

    function execRemove(method, hashid) {
        $("#action-form").attr('action', 'tahun-periode/delete/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willRemove(id, method) {
        swal({
            title: "Apakah Anda Yakin?",
            text: "anda yakin menghapus data ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willDelete) {
            if (willDelete) {
                if (method === "DELETE") execRemove('PATCH', id)
                    else execRemove('DELETE', id)
                }else{
                    swal("Aksi Dibatalkan", "", "error");
                }
            });
    };

    function execStatusSetujui(method, hashid) {
        $("#action-form").attr('action', 'approval-anggaran-setujui/set-status/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willStatusSetujui(id, method, nama) {
        swal({
            title: "Approval Anggaran?",
            text: "anda yakin ingin menyetujui anggaran "+nama+" ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willStatusSetujui) {
            if (willStatusSetujui) {
                if (method === "STATUS") execStatusSetujui('PUT', id)
                    else execStatusSetujui('STATUS', id)

                }
        });
    }

    function execStatusTolak(method, hashid) {
        $("#action-form").attr('action', 'approval-anggaran-ditolak/set-status/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willStatusTolak(id, method, nama) {
        swal({
            title: "Approval Anggaran?",
            text: "anda yakin ingin menolak anggaran "+nama+" ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willStatusTolak) {
            if (willStatusTolak) {
                if (method === "STATUS") execStatusTolak('PUT', id)
                    else execStatusTolak('STATUS', id)

                }
        });
    }

    function restore (hashid) {
        $("#action-form").attr('action', 'tahun-periode/restore/' + hashid);
        $("#action-form input[name=_method]").val("POST");
        $("#action-form").submit();
    };
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/approval_anggaran/index.blade.php ENDPATH**/ ?>