@extends('layouts.app')
@section('content')
<div class="content-heading">
	<div>
		Slip Gaji
	</div>
</div>
<div class="container-fluid">
	<div class="col-sm-12">
		<div class="card">
			<div class="card-header">
				<div class="card-body">
					@if( session('msg') )
					<?php $msg = session('msg'); ?>
					<div class="alert alert-{{ $msg['type'] }} alert-remove">
						{!! $msg['text'] !!}
					</div>
					@endif
				</div>
				<div class="row">
					<div class="col-sm-12">
						<h4 class="popover-header">{{ session()->get('nama') }}</h4>
						<div class="popover-body">
							<div class="d-flex align-items-center mb-3"><img class="mr-3 rounded-circle thumb48" src="{{ url_foto(session()->get('foto')) }}" alt="Image">
								<p class="m-0">
									NIK ({{ session()->get('sEmpID') }})
									<br>
									Jabatan ({{ $unit->data->sDescription }})
								</p>
							</div>
						</div>
					</div>
					<div class="col-sm-3">
						<a href="" data-toggle="modal" data-target="#modal-konfirmasi">
							<div class="jumbotron bg-success-dark">
								<h2 class="text-white">
									<span class="fas fa-money-bill-wave">&nbsp;&nbsp;Lihat Gaji</span>
								</h2>
							</div>	
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('body-area')
<!-- Modal Import -->
<div class="modal fade" id="modal-konfirmasi" tabindex="-1" role="dialog" aria-labelledby="modal-konfirmasi-label" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title" id="modal-konfirmasi-label">Konfirmasi Pasword</h4>
				<button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<div class="modal-body">
				<form id="action-form" action="{{ route('gaji.konfirmasi') }}" method="POST">
					@csrf
					<div class="form-group">
						<div class="input-group with-focus">
							<input maxlength="30" class="form-control border-right-0" type="password" name="password" placeholder="Masukan Password" required="required" />
							<div class="input-group-append">
								<span class="input-group-text text-muted bg-transparent border-left-0"><em class="fa fa-lock"></em></span>
							</div>
						</div>
						@if ($errors->has('password'))
						<span class="invalid-feedback">
							<strong>{{ $errors->first('password') }}</strong>
						</span>
						@endif
					</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-secondary" type="button" data-dismiss="modal">Batal</button>
					<button class="btn btn-purple" type="submit">Konfirmasi</button>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('scripts')
<script src="{{ mix('/js/sweetalert.js') }}"></script>
<script src="{{ mix('/js/datatable.js') }}"></script>
<script>
	var x = document.getElementById("verify");
	var submited = document.getElementById("submited");

	$(document).ready(function(){
		document.getElementById("verify").setAttribute("class", "whirl traditional"); 
		if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(showPosition);
		} else {
			x.innerHTML = "Geolocation is not supported by this browser.";
		}
	});

	function showPosition(position) {
		verifyLocation(position.coords.longitude, position.coords.latitude);
		x.innerHTML = "Latitude: " + position.coords.latitude +
		"<br>Longitude: " + position.coords.longitude;
	}

	function verifyLocation(longitude, latitude) {
		$.get("{{ route('absensi.verify_location') }}",{
			longitude:longitude,
			latitude:latitude
		},function(res){
			document.getElementById("verify").setAttribute("class", "");
			if (res.VerifyLocation == 200) {
				document.getElementById("lokasi").setAttribute("class", "badge badge-success");
				document.getElementById("lokasi").innerHTML = "Anda Berada Di lokasi Anda Bekerja";
				$('#submited').attr('style','display:show;');
			}else{
				document.getElementById("lokasi").setAttribute("class", "badge badge-danger");
				document.getElementById("lokasi").innerHTML = "Anda Tidak Berada Di lokasi Anda Bekerja";
				$('#submited').attr('style','display:none;');
			}
		},'json');
	}
</script>
@endsection