@extends('layouts.app')
@section('content')
<div class="content-heading">
	<div>
		Data Pengguna
	</div>
</div>
<div class="container-fluid">
	<div class="col-md-6 offset-md-3">
		<div class="card">
			<div class="card-header">
				<div class="card-title">
					Edit pengguna
					<div class="float-right">
						
					</div>
				</div>
			</div>
			<div class="card-body">
				@if( session('msg') )
				<?php $msg = session('msg'); ?>
				<div class="alert alert-{{ $msg['type'] }} alert-remove">
					{!! $msg['text'] !!}
				</div>
				@endif
				<form action="{{ route('user.update', $user->hashid) }}" method="POST">
					@method('PUT')
					@csrf
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama" value="{{ old('nama') ? old('nama') : $user->nama }}" placeholder="" />
							@if ($errors->has('nama'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('nama') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Email</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="email" value="{{ old('email') ? old('email') : $user->email }}" placeholder="" />
							@if ($errors->has('email'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('email') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Hak Akses</label>
						<div class="col-sm-7">
							<select class="form-control" name="role" required="">
								<option value="">-- Pilih Hak Akses --</option>
								<option {{ $user->role == 2 ? 'selected' : '' }} value="2">Kepala Desa</option>
								<option {{ $user->role == 3 ? 'selected' : '' }} value="3">Sekretaris Desa</option>
								<option {{ $user->role == 4 ? 'selected' : '' }} value="4">Badan Permusyawaratan Desa</option>
							</select>
							@if ($errors->has('email'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('email') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Username</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="username" value="{{ old('username') ? old('username') : $user->username }}" placeholder="" />
							@if ($errors->has('username'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('username') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right"></label>
						<div class="col-sm-7">
							Ganti Password ? <input type="checkbox" name="" class="mt-2" onclick="checkPass()" id="check"> 
						</div>
					</div>
					<div style="display: none;" id="pass">
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Password Baru</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" type="password" id="pw1" name="password_baru" value="{{ old('password_baru') }}" placeholder="" />
								@if ($errors->has('password_baru'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('password_baru') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Konfirmasi Password Baru</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" type="password" id="pw2" name="konfirmasi_password" value="{{ old('konfirmasi_password') }}" placeholder="" />
								@if ($errors->has('konfirmasi_password'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('konfirmasi_password') }}</strong>
								</span>
								@endif
							</div>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="form-group row">
							<div class="col-xl-12 text-center">
								<a href="{{ route('user.index') }}" class="btn btn-secondary">Kembali</a>
								<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>

@endsection
@section('scripts')
<script type="text/javascript">
	window.onload = function () {
		document.getElementById("pw1").onchange = validatePassword;
		document.getElementById("pw2").onchange = validatePassword;
	}

	function validatePassword(){
		var pass2=document.getElementById("pw2").value;
		var pass1=document.getElementById("pw1").value;
		if(pass1!=pass2)
			document.getElementById("pw2").setCustomValidity("Konfirmasi Password Tidak Sama, Coba Lagi");
		else
			document.getElementById("pw2").setCustomValidity('');
	}

	function checkPass() {
		var checkBox = document.getElementById("check");
		var pass = document.getElementById("pass");
		if (checkBox.checked == true){
			pass.style.display = "block";
			$("#pw1").attr('required', '');
			$("#pw2").attr('required', '');
		} else {
			pass.style.display = "none";
			$("#pw1").removeAttr('required');
			$("#pw2").removeAttr('required');
		}
	}
</script>
@endsection