(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["/js/notify"],{

/***/ "./resources/js/angle/modules/elements/notify.js":
/*!*******************************************************!*\
  !*** ./resources/js/angle/modules/elements/notify.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function($) {/**=========================================================
 * Module: notify.js
 * Create toggleable notifications that fade out automatically.
 * Based on Notify addon from UIKit (http://getuikit.com/docs/addons_notify.html)
 * [data-toggle="notify"]
 * [data-options="options in json format" ]
 =========================================================*/
(function () {
  'use strict';

  $(initNotify);

  function initNotify() {
    var Selector = '[data-notify]',
        autoloadSelector = '[data-onload]',
        doc = $(document);
    $(Selector).each(function () {
      var $this = $(this),
          onload = $this.data('onload');

      if (onload !== undefined) {
        setTimeout(function () {
          notifyNow($this);
        }, 800);
      }

      $this.on('click', function (e) {
        e.preventDefault();
        notifyNow($this);
      });
    });
  }

  function notifyNow($element) {
    var message = $element.data('message'),
        options = $element.data('options');
    if (!message) $.error('Notify: No message specified');
    $.notify(message, options || {});
  }
})();
/**
 * Notify Addon definition as jQuery plugin
 * Adapted version to work with Bootstrap classes
 * More information http://getuikit.com/docs/addons_notify.html
 */


(function () {
  var containers = {},
      messages = {},
      notify = function notify(options) {
    if ($.type(options) == 'string') {
      options = {
        message: options
      };
    }

    if (arguments[1]) {
      options = $.extend(options, $.type(arguments[1]) == 'string' ? {
        status: arguments[1]
      } : arguments[1]);
    }

    return new Message(options).show();
  },
      closeAll = function closeAll(group, instantly) {
    if (group) {
      for (var id in messages) {
        if (group === messages[id].group) messages[id].close(instantly);
      }
    } else {
      for (var id in messages) {
        messages[id].close(instantly);
      }
    }
  };

  var Message = function Message(options) {
    var $this = this;
    this.options = $.extend({}, Message.defaults, options);
    this.uuid = "ID" + new Date().getTime() + "RAND" + Math.ceil(Math.random() * 100000);
    this.element = $([// alert-dismissable enables bs close icon
    '<div class="uk-notify-message alert-dismissable">', '<a class="close">&times;</a>', '<div>' + this.options.message + '</div>', '</div>'].join('')).data("notifyMessage", this); // status

    if (this.options.status) {
      this.element.addClass('alert alert-' + this.options.status);
      this.currentstatus = this.options.status;
    }

    this.group = this.options.group;
    messages[this.uuid] = this;

    if (!containers[this.options.pos]) {
      containers[this.options.pos] = $('<div class="uk-notify uk-notify-' + this.options.pos + '"></div>').appendTo('body').on("click", ".uk-notify-message", function () {
        $(this).data("notifyMessage").close();
      });
    }
  };

  $.extend(Message.prototype, {
    uuid: false,
    element: false,
    timout: false,
    currentstatus: "",
    group: false,
    show: function show() {
      if (this.element.is(":visible")) return;
      var $this = this;
      containers[this.options.pos].show().prepend(this.element);
      var marginbottom = parseInt(this.element.css("margin-bottom"), 10);
      this.element.css({
        "opacity": 0,
        "margin-top": -1 * this.element.outerHeight(),
        "margin-bottom": 0
      }).animate({
        "opacity": 1,
        "margin-top": 0,
        "margin-bottom": marginbottom
      }, function () {
        if ($this.options.timeout) {
          var closefn = function closefn() {
            $this.close();
          };

          $this.timeout = setTimeout(closefn, $this.options.timeout);
          $this.element.hover(function () {
            clearTimeout($this.timeout);
          }, function () {
            $this.timeout = setTimeout(closefn, $this.options.timeout);
          });
        }
      });
      return this;
    },
    close: function close(instantly) {
      var $this = this,
          finalize = function finalize() {
        $this.element.remove();

        if (!containers[$this.options.pos].children().length) {
          containers[$this.options.pos].hide();
        }

        delete messages[$this.uuid];
      };

      if (this.timeout) clearTimeout(this.timeout);

      if (instantly) {
        finalize();
      } else {
        this.element.animate({
          "opacity": 0,
          "margin-top": -1 * this.element.outerHeight(),
          "margin-bottom": 0
        }, function () {
          finalize();
        });
      }
    },
    content: function content(html) {
      var container = this.element.find(">div");

      if (!html) {
        return container.html();
      }

      container.html(html);
      return this;
    },
    status: function status(_status) {
      if (!_status) {
        return this.currentstatus;
      }

      this.element.removeClass('alert alert-' + this.currentstatus).addClass('alert alert-' + _status);
      this.currentstatus = _status;
      return this;
    }
  });
  Message.defaults = {
    message: "",
    status: "normal",
    timeout: 5000,
    group: null,
    pos: 'top-center'
  };
  $["notify"] = notify;
  $["notify"].message = Message;
  $["notify"].closeAll = closeAll;
  return notify;
})();
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ 29:
/*!*************************************************************!*\
  !*** multi ./resources/js/angle/modules/elements/notify.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! X:\proyect\wb\angle4\development\laravel\resources\js\angle\modules\elements\notify.js */"./resources/js/angle/modules/elements/notify.js");


/***/ })

},[[29,"/js/manifest","/js/vendor"]]]);