<?php $__env->startSection('content'); ?>
<div class="content-heading">
    <div>
        Anggaran <span class="badge badge-success"><?php echo e($vtahun_periode->nama); ?></span>
    </div>
</div>
<div class="container-fluid">
  <div class="card">
   <div class="card-header">
    <div class="card-title">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <select id="tahun" onchange="setChange();" class="form-control" required>
                        <?php $__currentLoopData = $tahun_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php echo e($tahun_id->hashid==$row->hashid ?'selected':''); ?> value="<?php echo e($row->hashid); ?>"><?php echo e($row->nama); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="float-right">
                    <!-- <a href="<?php echo e(route('anggaran.create')); ?>" class="btn btn-primary">Data Baru</a> -->
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-body">
    <table class="table table-bordered table-hover table-sm">
        <tbody>
            <tr>
                <td class="text-right" style="color:black;"><b id="total_masuk"></b></td>
                <td class="text-right" width="15%" style="color: black;"><strong>Total Pemasukan</strong></td>
            </tr>
            <tr>
                <td class="text-right" style="color:black;"><b id="total_keluar"></b></td>
                <td class="text-right" width="15%" style="color: black;"><strong>Total Pengeluaran</strong></td>
            </tr>
            <tr>
                <td class="text-right" style="color:black;"><b id="jumlah_total"></b></td>
                <td class="text-right" width="15%" style="color: black;"><strong>Sisa Anggaran</strong></td>
            </tr>
        </tbody>
    </table>
</div>
<div class="card-body">
    <?php if( session('msg') ): ?>
    <?php $msg = session('msg'); ?>
    <div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
        <?php echo $msg['text']; ?>

    </div>
    <?php endif; ?>
    <div class="table-responsive">
        <table class="table table-bordered table-hover table-sm" id="datatable" style="width: 100%;">
            <thead>
                <tr>
                    <th class="text-center">No</th>
                    <th class="text-center" width="12%">Tanggal Diajukan</th>
                    <th class="text-center" width="12%">Tanggal Disetujui</th>
                    <th class="text-center">Nama</th>
                    <th class="text-center" width="10%">Tipe</th>
                    <th class="text-center">Nominal <br> Rp.</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
</div>
</div>
<form id="action-form" action="" method="POST">
    <?php echo e(csrf_field()); ?>

    <?php echo e(method_field('PATCH')); ?>

    <input type="hidden" name="id">
    <input type="hidden" name="tahun" id="hidden-tahun">
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
<script type="text/javascript">
    var table = null;
    $(document).ready(function(){
        getTotal();
        console.log('tahun', $('#tahun').val());

        table = $('#datatable').DataTable({
            "ajax" :{
                "url" : "<?php echo e(route('anggaran.get')); ?>",
                "type": "GET",
                "DataType":"JSON",
                "data":function(params){
                    params.tahun = $('#tahun').val();
                }
            },
            "processing" : true,
            "lengthMenu":[[25,50,100,-1],['25','50','100','All']],
            "order":[[0,'asc']],
            "columns" : [
            {
                "data" : null,
                "class":"text-center"
            },
            {"data" : "tanggal_diajukan"},
            {"data" : "tanggal_disetujui"},
            {"data" : "nama"},
            {
                "data" : "tipe", 
                "class":"text-center",
                "render" :function (data) {
                    let tipe = null;
                    if (data == "masuk") {
                        tipe = '<span class="badge badge-success">Pemasukan</span>';
                    }else{
                        tipe = '<span class="badge badge-danger">Pengeluaran</span>';
                    }
                    return tipe;
                }
            },
            {
                "data" : "nominal",
                "class" : "text-right",
                "render" :function (data) {
                    return data;
                }
            },
            { 
                "data": 'hashid',
                "class":"text-center",
                "render": function(data){
                    if ("<?php echo e(auth()->user()->role == 2); ?>") {
                        return '-';
                    }else if ("<?php echo e(auth()->user()->role == 4); ?>") {
                        return '-';
                    }else if ("<?php echo e(auth()->user()->role == 3); ?>") {
                        return '-';
                    }else{
                        return '<a href="anggaran/'+data+'/edit" class="btn btn-success btn-sm">Edit</a> <button type="button" title="delete" onclick="willRemove(\''+data+'\')" class="btn btn-danger btn-sm">Delete</button>';
                    }
                }
            }
            ]
        });
        setChange();
        table.on( 'order.dt search.dt', function () {
            table.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            });
        }).draw();
    });

    function getTotal() {
        $.get("<?php echo e(route('anggaran.get-total')); ?>",{tahun:$('#tahun').val()},function(res){
            console.log('data', res.data.total_masuk);
            document.getElementById('total_masuk').innerHTML = res.data.total_masuk;
            document.getElementById('total_keluar').innerHTML = res.data.total_keluar;
            document.getElementById('jumlah_total').innerHTML = res.data.jumlah_total;
        },'json');
    }

    function formatRupiah(angka, prefix){
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
        split           = number_string.split(','),
        sisa            = split[0].length % 3,
        rupiah          = split[0].substr(0, sisa),
        ribuan          = split[0].substr(sisa).match(/\d{3}/gi);

        if(ribuan){
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? ' ' + rupiah : '');
    }

    function setChange() 
    {
        let tahun = $('#tahun').val();
        console.log('tahun_id', tahun);
        getTotal();
        table.ajax.reload(null,false);
    }

    function execRemove(method, hashid) {
        $("#action-form").attr('action', 'anggaran/delete/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willRemove(id, method) {
        swal({
            title: "Apakah Anda Yakin?",
            text: "Menghapus data ini memerlukan persetujuan dari Kepala Desa?",
            icon: "warning",
            buttons: ["Batal", "Ajukan"]
        })
        .then(function(willDelete) {
            if (willDelete) {
                if (method === "DELETE") execRemove('PATCH', id)
                    else execRemove('PATCH', id)
                }else{
                    swal("Aksi Dibatalkan", "", "error");
                }
            });
    };

    function execStatus(method, hashid) {
        $("#action-form").attr('action', 'tahun-periode/set-status/' + hashid);
        $("#action-form input[name=_method]").val(method);
        $("#action-form").submit();
    }

    function willStatus(id, method, periode) {
        swal({
            title: "Aktifkan Tahun Periode?",
            text: "anda yakin ingin mengaktifkan "+periode+" ini?",
            icon: "warning",
            buttons: ["Batal", "Ya"]
        })
        .then(function(willStatus) {
            if (willStatus) {
                if (method === "STATUS") execStatus('PUT', id)
                    else execStatus('STATUS', id)

                }
        });
    }

    function restore (hashid) {
        $("#action-form").attr('action', 'tahun-periode/restore/' + hashid);
        $("#action-form input[name=_method]").val("POST");
        $("#action-form").submit();
    };
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/anggaran/index.blade.php ENDPATH**/ ?>