<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Data Batik
	</div>
</div>
<div class="container-fluid">
	<div class="col-md-8 offset-md-2">
		<div class="card">
			<div class="card-header">
				<div class="card-title">
					Edit Data Batik
					<div class="float-right">

					</div>
				</div>
			</div>
			<div class="card-body">
				<form action="<?php echo e(route('batik.edit', $batik->hashid)); ?>" method="POST" enctype="multipart/form-data">
					<?php echo method_field('PUT'); ?>
					<?php echo csrf_field(); ?>
					<input type='hidden' name='deleted' id="deleted" value=''>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama" value="<?php echo e(old('nama') ? old('nama') : $batik->nama); ?>" placeholder="Nama Batik" />
							<?php if($errors->has('nama')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('nama')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Foto</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" type="file" name="foto" accept="image/*" value="<?php echo e(old('foto')); ?>" placeholder="" />
							<small style="color: orange;">*kosongakan foto jika tidak ingin merubah foto</small>
							<?php if($errors->has('foto')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('foto')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Makna</label>
						<div class="col-sm-7">
							<textarea autofocus class="form-control" required type="text" name="makna" value="<?php echo e(old('makna') ? old('makna') : $batik->makna); ?>" placeholder="Makna dari batik"><?php echo e(old('makna') ? old('makna') : $batik->makna); ?></textarea>
							<?php if($errors->has('makna')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('makna')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Motif</label>
						<div class="col-sm-7">
							<textarea autofocus class="form-control" required type="text" name="motif" value="<?php echo e(old('motif') ? old('motif') : $batik->motif); ?>" placeholder="Motif Batik"><?php echo e(old('motif') ? old('motif') : $batik->motif); ?></textarea>
							<?php if($errors->has('motif')): ?>
							<span class="invalid-feedback">
								<strong><?php echo e($errors->first('motif')); ?></strong>
							</span>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right"></label>
						<div class="col-sm-7">
							<div class="float-right">
								<a href="#show-form-store" class="btn btn-primary open-form btn-sm" type="button" data-toggle="modal">
									Tambah Proses
								</a>
							</div>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right"></label>
						<div class="col-sm-7">
							<?php if( session('msg') ): ?>
							<?php $msg = session('msg'); ?>
							<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
								<?php echo $msg['text']; ?>

							</div>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right"></label>
						<div class="col-sm-7 table-responsive">
							<table class="table table-hover table-bordered">
								<thead>
									<tr>
										<td>No</td>
										<td>Nama</td>
										<td>Foto</td>
										<td>Aksi</td>
									</tr>
								</thead>
								<tbody>
									<?php $i= 1; ?>
									<?php $__currentLoopData = $proses_batik; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($i++); ?></td>
										<td><?php echo e($row->nama); ?></td>
										<td>
											<img src="<?php echo e($row->foto != null ? asset('storage/batik_proses/'.$row->foto) :  asset('logo.png')); ?>" width="50px">
										</td>
										<td>
											<a href="#show-form-edit" data-id="<?php echo e($row->id); ?>" data-nama="<?php echo e($row->nama); ?>" class="btn btn-success open-form-edit btn-sm" type="button" data-toggle="modal"><i class="fas fa-pencil-alt" ></i>
											</a>
											<button type="button" title="delete" onclick="willRemove('<?php echo e($row->id); ?>','DESTROY')" class="btn btn-danger btn-sm"> 
												<i class="fa fa-trash"></i>
											</button>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="form-group row">
							<div class="col-xl-12 text-center">
								<a href="<?php echo e(route('batik.index')); ?>" class="btn btn-secondary">Kembali</a>&nbsp;
								<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<form id="action-form" action="<?php echo e(route('proses_batik.destroy')); ?>" method="POST">
	<?php echo e(csrf_field()); ?>

	<?php echo e(method_field('PATCH')); ?>

	<input type="hidden" name="id">
</form>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-area'); ?>
<div id="show-form-store" tabindex="-1" role="dialog" aria-labelledby="form" aria-hidden="true" class="modal fade">
	<div class="modal-dialog modal-dm">
		<div class="modal-content">
			<div class="modal-header">
				Tambah Proses Batik
				<button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<div class="modal-body">
				<form action="<?php echo e(route('proses_batik.store')); ?>" method="post" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="form-group">
						<div class="modal-body">
							<input type="hidden" name="batik_id" value="<?php echo e($batik->id); ?>">
							<div class="form-group">
								<b>&nbsp;Nama Proses</b>
								<input type="text" required name="nama_proses" class="form-control" required placeholder="masukan nama proses" />
							</div>
							<div class="form-group">
								<b class="mt-3">&nbsp;Foto Proses</b>
								<input type="file" required name="foto_proses" class="form-control" required />
							</div>
						</div>
					</div>
					<p class="text-center">
						<button class="btn btn-primary"><i class="fas fa-check"></i> Simpan</button>
					</p>
				</form>
			</div>
		</div>
	</div>
</div>

<div id="show-form-edit" tabindex="-1" role="dialog" aria-labelledby="form" aria-hidden="true" class="modal fade">
	<div class="modal-dialog modal-dm">
		<div class="modal-content">
			<div class="modal-header">
				Tambah Proses Batik
				<button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<div class="modal-body">
				<form action="<?php echo e(route('proses_batik.update')); ?>" method="post" enctype="multipart/form-data">
					<?php echo method_field('PUT'); ?>
					<?php echo csrf_field(); ?>
					<div class="form-group">
						<div class="modal-body">
							<input type="hidden" name="id" value="" id="id">
							<div class="form-group">
								<b>&nbsp;Nama Proses</b>
								<input type="text" required name="nama_proses" class="form-control" id="nama_proses" required placeholder="masukan nama proses" />
							</div>
							<div class="form-group">
								<b class="mt-3">&nbsp;Foto Proses</b>
								<input type="file" name="foto_proses" class="form-control"/>
								<small>*kosongkan foto jika tidak ingin merubah foto sebelumnya</small>
							</div>
						</div>
					</div>
					<p class="text-center">
						<button class="btn btn-primary"><i class="fas fa-check"></i> Simpan</button>
					</p>
				</form>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
<script type="text/javascript">

	$(document).on("click", ".open-form-edit", function () {
		let id = $(this).data('id');
		let nama = $(this).data('nama');
		$(".modal-body #id").val( id );
		$(".modal-body #nama_proses").val( nama );
	});

	function willRemove(id, method) {
		swal({
			title: "Apakah Anda Yakin?",
			text: "anda yakin menghapus data ini?",
			icon: "warning",
			buttons: ["Batal", "Ya"]
		})
		.then(function(willDelete) {
			if (willDelete) {
				$("#action-form input[name=_method]").val("DELETE");
				$("#action-form input[name=id]").val(id);
				$("#action-form").submit();
			}
		});
	};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\batik-paseban\resources\views/pages/batik/edit.blade.php ENDPATH**/ ?>