<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Profile
	</div>
</div>
<div class="container-fluid">
	<!-- DATATABLE DEMO 1-->
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				
			</div>
		</div>
		<div class="card-body">
			<?php if( session('msg') ): ?>
			<?php $msg = session('msg'); ?>
			<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
				<?php echo $msg['text']; ?>

			</div>
			<?php endif; ?>
			<div class="row">
				<div class="col-sm-8">
					<form action="<?php echo e(route('profile.update', $profile->hashid)); ?>" method="POST" enctype="multipart/form-data">
						<?php echo method_field('PUT'); ?>
						<?php echo csrf_field(); ?>
						<div class="form-group">
							<label><b>Title</b></label>
							<input type="text" name="name" class="form-control" placeholder="Tuliskan title disini.. (Sejarah)" value="<?php echo e($profile ? $profile->name : ''); ?>">
						</div>
						<div class="form-group">
							<label><b>Tuliskan Sesuatu</b></label>
							<textarea class="form-control" rows="15" placeholder="Tuliskan Sesuatu disini.. (Di tepi jalan raya)" name="sejarah"><?php echo e($profile ? $profile->sejarah_singkat : ''); ?></textarea>
						</div>
						<div class="form-group">
							<label><b>Foto</b></label>
							<input type="file" name="foto" class="form-control">
						</div>
						<div class="form-group">
							<button class="btn btn-primary btn-sm">Simpan Perubahan</button>
						</div>
					</form>
				</div>
				<div class="col-sm-4">
					<img src="<?php echo e(asset('img/batik_paseban.png')); ?>" width="300px">
				</div>
			</div>
		</div>
	</div>
	<form id="action-form" action="" method="POST">
		<?php echo e(csrf_field()); ?>

		<?php echo e(method_field('PATCH')); ?>

		<input type="hidden" name="id">
	</form>
	<?php $__env->stopSection(); ?>
	<?php $__env->startSection('scripts'); ?>
	<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
	<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$('#datatable').DataTable();
		});

		function execRemove(method, hashid) {
			$("#action-form").attr('action', 'batik/delete/' + hashid);
			$("#action-form input[name=_method]").val(method);
			$("#action-form").submit();
		}

		function willRemove(id, method) {
			swal({
				title: "Apakah Anda Yakin?",
				text: "anda yakin menghapus data ini?",
				icon: "warning",
				buttons: ["Batal", "Ya"]
			})
			.then(function(willDelete) {
				if (willDelete) {
					if (method === "DELETE") execRemove('PATCH', id)
						else execRemove('DELETE', id)
					}
			});
		};

		function restore (hashid) {
			$("#action-form").attr('action', 'batik/restore/' + hashid);
			$("#action-form input[name=_method]").val("POST");
			$("#action-form").submit();
		};
	</script>
	<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\batik-paseban\resources\views/pages/profile/index.blade.php ENDPATH**/ ?>