<?php $__env->startSection('content'); ?>
<div class="content-heading">
    <div>
        Tahun Periode
    </div>
</div>
<div class="container">
    <div class="row">
        <div class="col-sm-8 offset-2">
            <div class="card card-custom">
                <div class="card-header">
                    <h3 class="card-title">
                        Edit Tahun Periode
                    </h3>
                    <br>
                    <?php if( session('msg') ): ?>
                    <?php $msg = session('msg'); ?>
                    <div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
                        <?php echo $msg['text']; ?>

                    </div>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('tahun_periode.update', $records->hashid)); ?>" method="POST">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label text-right">Tanggal Mulai</label>
                            <div class="col-sm-7">
                                <input autofocus class="form-control" required type="date" name="tanggal_mulai" id="tanggal_mulai" value="<?php echo e(old('tanggal_mulai') ? old('tanggal_mulai') : $records->tanggal_mulai); ?>" placeholder=""/>
                                <?php if($errors->has('tanggal_mulai')): ?>
                                <span class="invalid-feedback">
                                    <strong><?php echo e($errors->first('tanggal_mulai')); ?></strong>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label text-right">Tanggal Selesai</label>
                            <div class="col-sm-7">
                                <input autofocus class="form-control" required type="date" name="tanggal_selesai" id="tanggal_selesai"placeholder="" value="<?php echo e(old('tanggal_selesai') ? old('tanggal_selesai') : $records->tanggal_selesai); ?>"/>
                                <?php if($errors->has('tanggal_selesai')): ?>
                                <span class="invalid-feedback">
                                    <strong><?php echo e($errors->first('tanggal_selesai')); ?></strong>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group row">
                                <div class="col-xl-12 text-right">
                                    <a href="<?php echo e(route('tahun_periode.index')); ?>" class="btn btn-secondary">Kembali</a>
                                    <button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">

    $('input[type=date]#tanggal_mulai').change(function () {
        var inputHari = 1825 //Contoh aja hehe
        var hariKedepan = new Date(getTime($('#tanggal_mulai').val())+(inputHari*24*60*60*1000));
        console.log('date', getTime($('#tanggal_mulai').val()));
        console.log('date-mulai', $('#tanggal_mulai').val());
        document.getElementById("tanggal_selesai").value = formatDate(hariKedepan);
    });

    function getTime(value, utc) {
        var parts = value.split('-');
        parts[1] -= 1;
        if (utc) {
            return Date.UTC(parts[2], parts[1], parts[0]);
        }
        return new Date(parts[0], parts[1], parts[2]).getTime();
    }

    function formatDate(date) {
        var d = new Date(date),
        month = '' + (d.getMonth() + 1),
        day = '' + d.getDate(),
        year = d.getFullYear();
        if (month.length < 2) 
            month = '0' + month;
        if (day.length < 2) 
            day = '0' + day;
        return [year, month, day].join('-');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\kas-desa\resources\views/pages/tahun_periode/edit.blade.php ENDPATH**/ ?>