<?php $__env->startSection('content'); ?>
<div class="content-heading">
	<div>
		Data Motif
	</div>
</div>
<div class="container-fluid">
	<!-- DATATABLE DEMO 1-->
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				<a href="<?php echo e(route('motif.index')); ?>" class="<?php echo e($is_trash ? 'text-success':'text-muted'); ?>"> All
					<span class="badge badge-pill badge-info"><?php echo e($motif_count); ?></span>
				</a>
				&nbsp; | &nbsp;
				<a href="<?php echo e(route('motif.index')); ?>?status=trash" class="<?php echo e($is_trash ? 'text-muted':'text-danger'); ?>">
					Trash
					<span class="badge badge-pill badge-danger"><?php echo e($trash_count); ?></span>
				</a>
			</div>
		</div>
		<div class="card-body">
			<?php if( session('msg') ): ?>
			<?php $msg = session('msg'); ?>
			<div class="alert alert-<?php echo e($msg['type']); ?> alert-remove">
				<?php echo $msg['text']; ?>

			</div>
			<?php endif; ?>
			<div class="table-responsive">
				<table id="table-motif" class="table table-bordered table-striped table-hover dataTable" style="width: 100%;">
					<thead>
						<tr>
							<th class="text-center">No</th>
							<th class="text-center">Nama</th>
							<th class="text-center">Asal Daerah</th>
							<th class="text-center">Cara Pembuatan</th>
							<th class="text-center">Pembuat</th>
							<th class="text-center">Warna</th>
							<th class="text-center">Foto</th>
							<th class="text-center">Nilai Citra</th>
							<th class="text-center">Aksi</th> 
						</tr>
					</thead>
				</table>
			</div>
		</div>
	</div>
	<form id="action-form" action="" method="POST">
		<?php echo e(csrf_field()); ?>

		<?php echo e(method_field('PATCH')); ?>

		<input type="hidden" name="id">
	</form>
	<?php $__env->stopSection(); ?>
	<?php $__env->startSection('scripts'); ?>
	<script src="<?php echo e(mix('/js/sweetalert.js')); ?>"></script>
	<script src="<?php echo e(mix('/js/datatable.js')); ?>"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			var table_motif = $('#table-motif').DataTable({
				"scrollX": true,
				"lengthMenu": [[20, 50, 100, -1], [20, 50, 100, "All"]],
				"processing" : true,
				"serverSide" : true,
				"ajax" :{
					"url" : "<?php echo e(route('motif.get')); ?>",
					"type": "GET",
					"DataType":"JSON",
					"data":{'status':'<?php echo e($is_trash ? "trash":""); ?>'}
				},
				"order": [[ 1, 'asc' ]],
				"columns" : [
				{
					"data" : null,
					"class":"text-center"
				},
				{
					"data" : "nama",
					"class":"text-center"
				},
				{
					"data" : "asal_daerah",
					"class":"text-center"
				},
				{
					"data" : "cara_pembuatan",
					"class":"text-center"
				},
				{
					"data" : "nama_pembuat",
					"class": "text-center"
				},
				{
					"data" : "warna",
					"class":"text-center"
				},
				{
					"data" : "foto",
					"class":"text-center",
					"render": function(data){
						return '<img src="'+(data == null ? '<?php echo e(asset("storage/batik/dummy.png")); ?>':'<?php echo e(asset("storage/batik")); ?>/'+data)+'" width="50px" />';
					}
				},
				{
					"data" : "nilai_citra",
					"class": "text-center"
				},
				{ 
					"data": null,
					"class":"text-center",
					"render": function(data){
						if (data.deleted_at == null) 
						{
							return '<a href="motif/'+data['hashid']+'/edit" class="btn btn-success btn-sm waves-effect">Edit</a>&nbsp<button type="button" title="delete" onclick="willRemove(\''+data.hashid+'\',\'DELETE\')" class="btn btn-danger btn-sm">Delete</button>';
						}else{
							return '<button type="button" class="btn btn-success btn-sm" onclick="restore(\''+data.hashid+'\')" title="Restore">Restore</button>&nbsp;<button type="button" title="destroy" onclick="willRemove(\''+data.hashid+'\',\'DESTROY\')" class="btn btn-danger btn-sm">Destroy</button>';
						}
					}
				}
				]
			});

			table_motif.on( 'order.dt search.dt', function () {
				table_motif.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
					cell.innerHTML = i+1;
				});
			}).draw();
		});

		function execRemove(method, hashid) {
			$("#action-form").attr('action', 'motif/delete/' + hashid);
			$("#action-form input[name=_method]").val(method);
			$("#action-form").submit();
		}

		function willRemove(id, method) {
			swal({
				title: "Apakah Anda Yakin?",
				text: "anda yakin menghapus data ini?",
				icon: "warning",
				buttons: ["Batal", "Ya"]
			})
			.then(function(willDelete) {
				if (willDelete) {
					if (method === "DELETE") execRemove('PATCH', id)
						else execRemove('DELETE', id)
					}
			});
		};

		function restore (id) {
			$("#action-form").attr('action', 'motif/restore/' + id);
			$("#action-form input[name=_method]").val("POST");
			$("#action-form").submit();
		};
	</script>
	<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\PROGRAM_JANGAN_DIHAPUS\xampp73\htdocs\idam_tech\Laravel6\batik\resources\views/pages/motif/index.blade.php ENDPATH**/ ?>