<?php

namespace App\Http\Controllers\Personalia;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Ixudra\Curl\Facades\Curl;
use Stevebauman\Location\Facades\Location;

class GajiController extends Controller
{
	public function index(Request $request)
	{
		$unit = Curl::to(api_url('presensi/unit'))
		->withData([
			'sUnitID'=> $request->session()->get('sDeptID'), 
			'permission'=> 'get-berdasarkan-sUnitID',
		])->asJson()->post();
		return view('pages.personalia.gaji.index', compact('unit'));
	}

	public function konfirmasi(Request $request)
	{
		if (hash('sha256',$request->password) == session()->get('password')) {
			return redirect()->route('gaji.detail')->with('msg',['type'=>'success','text'=>'Konfirmasi password Benar..']);
		} else {
			return redirect()->route('gaji.index')->with('msg',['type'=>'danger','text'=>'Ops.. Konfirmasi password salah silahkan coba lagi..']);
		}
	}

	public function detail(Request $request)
	{

		$unit = Curl::to(api_url('presensi/unit'))
		->withData([
			'sUnitID'=> $request->session()->get('sDeptID'), 
			'permission'=> 'get-berdasarkan-sUnitID',
		])->asJson()->post();

		if ($request->has('periode') && $request->has('bulan')) {
			$displayGaji = Curl::to(api_url('displayGaji'))
			->withData([
				'user'=> $request->session()->get('sEmpID'), 
				'periode'=> $request->get('periode')."".$request->get('bulan'),
			])->asJson()->post();
			$req_bulan = $request->bulan;
			$req_periode = $request->periode;
			if ($displayGaji == null) {
				$displayGaji = null;
			}else{
			    $displayGaji = $displayGaji;
			}
		} else {
			$req_bulan = 0;
			$req_periode = 0;
			$displayGaji = null;
		}

		return view('pages.personalia.gaji.detail', compact('unit','displayGaji','req_bulan','req_periode'));
	}

	public function download(Request $request)
	{
		$download = Curl::to(api_url('GajiDownload'))
		->withData([
			'user'=> $request->session()->get('sEmpID'), 
			'periode'=> $request->periode,
		])->asJson()->post();

		return back()->with('msg',['type'=>'success','text'=>'Hasil Rekap Slip Gaji Terkirim ke Email!, Silahkan Cek Email Anda'])->withInput();
	}
}
