@extends('layouts.master')
@section('content')


<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<!-- <h1 class="m-0 text-dark">Tambah User</h1> -->
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class="breadcrumb-item"><a href="{{ route('sentra-batik.index') }}">Sentra Batik</a></li>
					<li class="breadcrumb-item">Create</li>
				</ol>
			</div>
		</div>
	</div>
</div>

<div class="container-fluid">
	<div class="row">
		<div class="col-sm-6 offset-sm-3">
			<div class="card card-outline card-primary">
				<div class="card-header">
					<h3 class="card-title">Silahkan tambah sentra batik</h3>
				</div>
				<div class="card-body">
					<form action="{{ route('sentra-batik.store') }}" method="POST">
						@csrf
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Nama Sentra</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" required type="text" name="nama" value="{{ old('nama') }}" placeholder="" />
								@if ($errors->has('nama'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('nama') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Lokasi</label>
							<div class="col-sm-7">
								<textarea autofocus class="form-control" required type="text" name="lokasi" value="{{ old('lokasi') }}" placeholder="" >{{ old('lokasi') }}</textarea>
								@if ($errors->has('lokasi'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('lokasi') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-form-label text-right">Tahun Berdiri</label>
							<div class="col-xl-7">
								<select required name="tahun" class="custom-select custom-select-xl @error('tahun') is-invalid @enderror">{{ old('tahun') }}>
									<option value="">Pilih Tahun</option>
									<?php
									$thn_skr = date('Y');
									for ($x = $thn_skr; $x >= 1998; $x--) {
										?>
										<option value="{{ $x }}">{{ $x }}</option>
										<?php
									}
									?>
								</select>
								@error('tahun')
								<div class="invalid-feedback">{{$message}}</div>
								@enderror
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Pemilik</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" required type="text" name="pemilik" value="{{ old('pemilik') }}" placeholder="" />
								@if ($errors->has('pemilik'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('pemilik') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="col-sm-12">
							<div class="form-group row">
								<div class="col-xl-12 text-center">
									<a href="{{ route('sentra-batik.index') }}" class="btn btn-secondary">Kembali</a>
									<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection
@section('scripts')

@endsection