@extends('layouts.app')
@section('content')
    <div class="content-heading">
        <div>
            Pengaturan User
        </div>
    </div>
    <div class="container-fluid">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Edit Jenis Kelas
                        <div class="float-right">
                            
                        </div>
                    </div>
                </div>
                <div class="card-body">
					<form action="{{ route('user.update', $user->id) }}" method="POST">
						@method('PUT')
						@csrf
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Nama</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" required type="text" name="nama" value="{{ old('nama') ? old('nama'):$user->nama  }}" placeholder="" />
								@if ($errors->has('nama'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('nama') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Email</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" required type="text" name="email" value="{{ old('email') ? old('nama'):$user->email  }}" placeholder="" />
								@if ($errors->has('email'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('email') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Sentra Batik</label>
							<div class="col-sm-7">
								<select name="sentra_id" class="custom-select custom-select-xl @error('sentra_id') is-invalid @enderror">{{ old('sentra_id') }}>
									<option value="">Pilih Sentra Batik</option>
									@foreach($sentra as $row)
										<option value="{{$row->id}}" @if(old('sentra_id', $user->sentra_id) == $row->id) selected @endif>{{ $row->nama }}</option>
									@endforeach
								</select>
								@error('sentra_id')
								<div class="invalid-feedback">{{$message}}</div>
								@enderror
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-form-label text-right">Role</label>
							<div class="col-xl-7">
								<select required name="role" class="custom-select custom-select-xl @error('role') is-invalid @enderror">{{ old('role') }}>
									<option value="">Pilih Role</option>
									<option value="1" @if(old('role', $user->role) == "1") selected @endif>Superadmin</option>
									<option value="2" @if(old('role', $user->role) == "2") selected @endif>Admin</option>
									<option value="3" @if(old('role', $user->role) == "3") selected @endif>Pengguna</option>
								</select>
								@error('role')
								<div class="invalid-feedback">{{$message}}</div>
								@enderror
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Username</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" required type="text" name="username" value="{{ old('username') ? old('nama'):$user->username  }}" placeholder="" />
								@if ($errors->has('username'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('username') }}</strong>
								</span>
								@endif
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label text-right">Password</label>
							<div class="col-sm-7">
								<input autofocus class="form-control" type="password" name="password" value="{{ old('password') }}" placeholder="" />
								@if ($errors->has('password'))
								<span class="invalid-feedback">
									<strong>{{ $errors->first('password') }}</strong>
								</span>
								@endif
								<span style="color: red; font-size: 12px">*kosongkan password jika tidak ingin merubah</span>
							</div>
						</div>
						<div class="col-sm-12">
							<div class="form-group row">
								<div class="col-xl-12 text-center">
									<a href="{{ route('user.index') }}" class="btn btn-secondary">Kembali</a>
									<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection
@section('scripts')

@endsection