@extends('layouts.app')
@section('content')
<div class="content-heading">
	<div>
		Sentra Batik
	</div>
</div>
<div class="container-fluid">
	<div class="col-md-6 offset-md-3">
		<div class="card">
			<div class="card-header">
				<div class="card-title">
					Edit Sentra Batik
					<div class="float-right">

					</div>
				</div>
			</div>
			<div class="card-body">
				<form action="{{ route('sentra-batik.update', $sentra->id) }}" method="POST">
					@method('PUT')
					@csrf
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Nama Sentra</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="nama" value="{{ old('nama') ? old('nama'):$sentra->nama }}" placeholder="" />
							@if ($errors->has('nama'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('nama') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Lokasi</label>
						<div class="col-sm-7">
							<textarea autofocus class="form-control" required type="text" name="lokasi" value="{{ old('lokasi') ? old('nama'):$sentra->lokasi }}" placeholder="" >{{ old('lokasi') ? old('nama'):$sentra->lokasi }}</textarea>
							@if ($errors->has('lokasi'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('lokasi') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xl-3 col-form-label text-right">Tahun Berdiri</label>
						<div class="col-xl-7">
							<select required name="tahun" class="custom-select custom-select-xl @error('tahun') is-invalid @enderror">{{ old('tahun') }}>
								<option value="">Pilih Tahun</option>
								<?php
								$thn_skr = date('Y');
								for ($x = $thn_skr; $x >= 1998; $x--) {
									?>
									<option value="{{ $x }}" @if(old('tahun', $sentra->tahun) == $x) selected @endif>{{ $x }}</option>
									<?php
								}
								?>
							</select>
							@error('tahun')
							<div class="invalid-feedback">{{$message}}</div>
							@enderror
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-3 col-form-label text-right">Pemilik</label>
						<div class="col-sm-7">
							<input autofocus class="form-control" required type="text" name="pemilik" value="{{ old('pemilik') ? old('nama'):$sentra->pemilik }}" placeholder="" />
							@if ($errors->has('pemilik'))
							<span class="invalid-feedback">
								<strong>{{ $errors->first('pemilik') }}</strong>
							</span>
							@endif
						</div>
					</div>
					<div class="col-sm-12">
						<div class="form-group row">
							<div class="col-xl-12 text-center">
								<a href="{{ route('sentra-batik.index') }}" class="btn btn-secondary">Kembali</a>
								<button class="btn btn-primary mb-2 mt-2" type="submit">Simpan</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>

@endsection
@section('scripts')

@endsection